<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;

class City extends Model
{
    protected $fillable = [
        'name',
        'state',
        'country',
        'latitude',
        'longitude',
        'is_active',
    ];

    protected function casts(): array
    {
        return [
            'latitude' => 'decimal:8',
            'longitude' => 'decimal:8',
            'is_active' => 'boolean',
        ];
    }

    // Relationships

    /**
     * Get routes starting from this city
     */
    public function routesFrom(): HasMany
    {
        return $this->hasMany(Route::class, 'from_city_id');
    }

    /**
     * Get routes ending at this city
     */
    public function routesTo(): HasMany
    {
        return $this->hasMany(Route::class, 'to_city_id');
    }

    // Helper Methods

    /**
     * Get the full city name (city, state)
     */
    public function getFullNameAttribute(): string
    {
        return "{$this->name}, {$this->state}";
    }
}
