<?php

/**
 * Laravel - A PHP Framework For Web Artisans
 * FOR SHARED HOSTING - Place this file in your public_html or www folder
 * 
 * This file is a modified version of public/index.php for shared hosting deployments.
 * 
 * STEPS TO DEPLOY:
 * 1. Upload all Laravel files to a folder ABOVE public_html (e.g., /home/username/ridepool/)
 * 2. Copy this file to public_html as index.php
 * 3. Copy .htaccess from public folder to public_html
 * 4. Copy all files from public folder to public_html (css, js, images, etc.)
 * 5. Update the paths below if needed
 */

use Illuminate\Foundation\Application;
use Illuminate\Http\Request;

define('LARAVEL_START', microtime(true));

// Set the public path to this directory
$publicPath = __DIR__;

// Adjust this path to point to your Laravel installation
// Common shared hosting paths:
// - /home/username/ridepool
// - /home/username/laravel
// - ../ridepool (one level up from public_html)
$laravelPath = __DIR__ . '/../ridepool';

// Determine if the application is in maintenance mode...
if (file_exists($maintenance = $laravelPath.'/storage/framework/maintenance.php')) {
    require $maintenance;
}

// Register the Composer autoloader...
require $laravelPath.'/vendor/autoload.php';

// Bootstrap Laravel and handle the request...
/** @var Application $app */
$app = require_once $laravelPath.'/bootstrap/app.php';

// Bind the public path
$app->bind('path.public', function() use ($publicPath) {
    return $publicPath;
});

$app->handleRequest(Request::capture());
