@extends('admin.layout')

@section('title', 'Vehicles')
@section('page-title', 'Vehicles Management')

@section('content')
    <div class="card">
        <div class="card-header">
            <h3 class="card-title">All Vehicles ({{ $vehicles->total() }})</h3>
        </div>
        <table class="table">
            <thead>
                <tr>
                    <th>Vehicle</th>
                    <th>Owner</th>
                    <th>License Plate</th>
                    <th>Seats</th>
                    <th>Color</th>
                    <th>Status</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                @forelse($vehicles as $vehicle)
                    <tr>
                        <td>
                            <div style="font-weight: 700;">{{ $vehicle->make }} {{ $vehicle->model }}</div>
                            <div style="font-size: 12px; color: #64748b;">{{ $vehicle->year }}</div>
                        </td>
                        <td>
                            <div class="user-cell">
                                <div class="user-avatar-sm">{{ substr($vehicle->driver->name ?? 'D', 0, 1) }}</div>
                                <div>
                                    <div style="font-weight: 600;">{{ $vehicle->driver->name ?? 'N/A' }}</div>
                                    <div style="font-size: 12px; color: #64748b;">{{ $vehicle->driver->phone ?? '' }}</div>
                                </div>
                            </div>
                        </td>
                        <td style="font-weight: 700;">{{ $vehicle->license_plate }}</td>
                        <td>{{ $vehicle->seats }}</td>
                        <td>
                            <div style="display: flex; align-items: center; gap: 8px;">
                                <div style="width: 20px; height: 20px; border-radius: 50%; background: {{ strtolower($vehicle->color) }}; border: 2px solid #e2e8f0;"></div>
                                {{ $vehicle->color }}
                            </div>
                        </td>
                        <td>
                            @if($vehicle->is_verified)
                                <span class="badge badge-success">Verified</span>
                            @else
                                <span class="badge badge-warning">Pending</span>
                            @endif
                        </td>
                        <td>
                            @if(!$vehicle->is_verified)
                                <form action="{{ route('admin.vehicles.verify', $vehicle->id) }}" method="POST" style="display: inline;">
                                    @csrf
                                    <button type="submit" class="btn btn-primary btn-sm">Verify</button>
                                </form>
                            @else
                                <span style="color: #10b981; font-size: 13px; font-weight: 600;">✓ Verified</span>
                            @endif
                        </td>
                    </tr>
                @empty
                    <tr>
                        <td colspan="7" style="text-align: center; color: #64748b; padding: 40px;">No vehicles found</td>
                    </tr>
                @endforelse
            </tbody>
        </table>
    </div>

    <!-- Pagination -->
    <div style="display: flex; justify-content: center; margin-top: 20px;">
        {{ $vehicles->links() }}
    </div>
@endsection
