@extends('layouts.app')

@section('title', 'Sign Up')

@section('styles')
<style>
    .auth-container {
        min-height: 80vh;
        display: flex;
        align-items: center;
        justify-content: center;
        padding: 20px 0;
    }

    .auth-card {
        background: white;
        border-radius: 24px;
        padding: 28px 24px;
        width: 100%;
        max-width: 400px;
        box-shadow: 0 10px 40px rgba(0,0,0,0.08);
    }

    .auth-header {
        text-align: center;
        margin-bottom: 24px;
    }

    .auth-logo {
        display: flex;
        justify-content: center;
        margin-bottom: 20px;
    }

    /* Logo - Exact Same as Main Website Header */
    .auth-logo .kkh-logo-2d {
        display: flex;
        flex-direction: column;
        align-items: center;
        text-decoration: none;
        position: relative;
        padding: 10px 0;
        transition: transform 0.3s ease;
    }

    .auth-logo .kkh-logo-2d:hover {
        transform: translateY(-2px);
    }

    .auth-logo .logo-svg-container {
        position: absolute;
        top: -5px;
        left: 50%;
        transform: translateX(-50%);
        width: 180px;
        height: 60px;
        pointer-events: none;
        z-index: 1;
    }

    .auth-logo .logo-svg-container svg {
        width: 100%;
        height: 100%;
        overflow: visible;
    }

    .auth-logo .arch-path {
        stroke: #00aff5;
        stroke-width: 3.5;
        stroke-linecap: round;
        fill: none;
        stroke-dasharray: 300;
        stroke-dashoffset: 300;
        animation: drawArchAuth 1.2s ease-out infinite;
    }

    .auth-logo .logo-dot {
        fill: #1e3a5f;
        opacity: 0;
        animation: dotFadeInAuth 3s ease-out infinite;
    }

    .auth-logo .dot-1 { animation-delay: 0.7s; }
    .auth-logo .dot-2 { animation-delay: 0.9s; }
    .auth-logo .dot-3 { animation-delay: 1.1s; }

    @keyframes drawArchAuth {
        0% { stroke-dashoffset: 300; }
        40% { stroke-dashoffset: 0; }
        100% { stroke-dashoffset: 0; }
    }

    @keyframes dotFadeInAuth {
        0% { opacity: 0; transform: scale(0.5); }
        30% { opacity: 1; transform: scale(1.2); }
        50% { opacity: 1; transform: scale(1); }
        100% { opacity: 1; transform: scale(1); }
    }

    .auth-logo .logo-text-2d {
        font-size: 32px;
        font-weight: 800;
        display: flex;
        align-items: center;
        line-height: 1;
        position: relative;
        z-index: 2;
        letter-spacing: -1.5px;
    }

    .auth-logo .kkh-2d {
        color: #00aff5;
        margin-right: 4px;
    }

    .auth-logo .ride-2d {
        color: #1e3a5f;
    }

    .auth-logo .logo-tagline-2d {
        font-size: 9px;
        font-weight: 700;
        color: rgba(30, 58, 95, 0.5);
        text-transform: uppercase;
        letter-spacing: 2px;
        margin-top: 2px;
    }

    .auth-title {
        font-size: 22px;
        font-weight: 800;
        color: #1e3a5f;
        margin-bottom: 4px;
    }

    .auth-subtitle {
        font-size: 13px;
        color: #64748b;
    }

    .form-group {
        margin-bottom: 16px;
    }

    .form-label {
        display: block;
        font-size: 11px;
        font-weight: 700;
        color: #64748b;
        text-transform: uppercase;
        margin-bottom: 6px;
    }

    .form-input {
        width: 100%;
        padding: 14px 16px;
        border: 2px solid #e2e8f0;
        border-radius: 12px;
        font-size: 14px;
        font-weight: 600;
        color: #1e3a5f;
        background: #f8fafc;
        transition: all 0.2s;
    }

    .form-input:focus {
        outline: none;
        border-color: #00aff5;
        background: white;
        box-shadow: 0 0 0 4px rgba(0, 175, 245, 0.1);
    }

    .password-strength {
        display: flex;
        gap: 4px;
        margin-top: 8px;
    }

    .strength-bar {
        flex: 1;
        height: 4px;
        background: #e2e8f0;
        border-radius: 2px;
    }

    .terms-check {
        display: flex;
        align-items: flex-start;
        gap: 10px;
        margin-bottom: 20px;
    }

    .terms-check input {
        width: 18px;
        height: 18px;
        margin-top: 2px;
        accent-color: #00aff5;
    }

    .terms-text {
        font-size: 12px;
        color: #64748b;
        line-height: 1.5;
    }

    .terms-text a {
        color: #00aff5;
        text-decoration: none;
        font-weight: 600;
    }

    .auth-btn {
        width: 100%;
        padding: 16px;
        background: linear-gradient(135deg, #00aff5, #10b981);
        color: white;
        border: none;
        border-radius: 14px;
        font-size: 15px;
        font-weight: 700;
        cursor: pointer;
        transition: all 0.2s;
    }

    .auth-btn:hover {
        transform: translateY(-2px);
        box-shadow: 0 10px 20px rgba(0, 175, 245, 0.3);
    }

    .auth-btn:active {
        transform: scale(0.98);
    }

    .divider {
        display: flex;
        align-items: center;
        gap: 16px;
        margin: 20px 0;
    }

    .divider-line {
        flex: 1;
        height: 1px;
        background: #e2e8f0;
    }

    .divider-text {
        font-size: 12px;
        color: #94a3b8;
        font-weight: 600;
    }

    .social-btns {
        display: flex;
        gap: 12px;
    }

    .social-btn {
        flex: 1;
        display: flex;
        align-items: center;
        justify-content: center;
        gap: 8px;
        padding: 12px;
        background: #f8fafc;
        border: 2px solid #e2e8f0;
        border-radius: 12px;
        font-size: 13px;
        font-weight: 600;
        color: #1e3a5f;
        cursor: pointer;
        transition: all 0.2s;
        text-decoration: none;
    }

    .social-btn:hover {
        background: white;
        border-color: #00aff5;
    }

    .social-icon {
        width: 20px;
        height: 20px;
    }

    .auth-footer {
        text-align: center;
        margin-top: 20px;
        font-size: 13px;
        color: #64748b;
    }

    .auth-footer a {
        color: #00aff5;
        font-weight: 700;
        text-decoration: none;
    }

    .alert-error {
        background: #fee2e2;
        color: #991b1b;
        padding: 12px 16px;
        border-radius: 12px;
        font-size: 13px;
        font-weight: 600;
        margin-bottom: 20px;
    }
</style>
@endsection

@section('content')
<div class="auth-container">
    <div class="auth-card">
        <div class="auth-header">
            <!-- Exact Same Logo Structure as Main Website Header -->
            <div class="auth-logo">
                <a href="{{ route('home') }}" class="kkh-logo-2d">
                    <div class="logo-svg-container">
                        <svg viewBox="0 0 200 60">
                            <path d="M5,45 Q5,10 160,10" class="arch-path" />
                            <circle cx="172" cy="12" r="3" class="logo-dot dot-1" />
                            <circle cx="185" cy="22" r="3" class="logo-dot dot-2" />
                            <circle cx="192" cy="38" r="3" class="logo-dot dot-3" />
                        </svg>
                    </div>
                    <div class="logo-text-2d">
                        <span class="kkh-2d">kkh</span>
                        <span class="ride-2d">ride</span>
                    </div>
                    <span class="logo-tagline-2d">Premium Travels</span>
                </a>
            </div>
            <h1 class="auth-title">Create Account</h1>
            <p class="auth-subtitle">Join thousands of carpoolers in Pakistan</p>
        </div>

        @if($errors->any())
            <div class="alert-error">
                @foreach($errors->all() as $error)
                    {{ $error }}<br>
                @endforeach
            </div>
        @endif

        <form action="{{ route('register.post') }}" method="POST">
            @csrf
            <input type="hidden" name="user_type" value="both">

            <div class="form-group">
                <label class="form-label">Full Name</label>
                <input type="text" name="name" class="form-input" placeholder="Your full name" value="{{ old('name') }}" required>
            </div>

            <div class="form-group">
                <label class="form-label">Email Address</label>
                <input type="email" name="email" class="form-input" placeholder="name@example.com" value="{{ old('email') }}" required>
            </div>

            <div class="form-group">
                <label class="form-label">Phone Number</label>
                <input type="tel" name="phone" class="form-input" placeholder="+92 300 1234567" value="{{ old('phone') }}" required>
            </div>

            <div class="form-group">
                <label class="form-label">Password</label>
                <input type="password" name="password" class="form-input" placeholder="Min 8 characters" required>
                <div class="password-strength">
                    <div class="strength-bar"></div>
                    <div class="strength-bar"></div>
                    <div class="strength-bar"></div>
                    <div class="strength-bar"></div>
                </div>
            </div>

            <div class="form-group">
                <label class="form-label">Confirm Password</label>
                <input type="password" name="password_confirmation" class="form-input" placeholder="Repeat password" required>
            </div>

            <div class="terms-check">
                <input type="checkbox" name="terms" required>
                <span class="terms-text">
                    I agree to the <a href="#">Terms of Service</a> and <a href="#">Privacy Policy</a>
                </span>
            </div>

            <button type="submit" class="auth-btn">Create Account</button>
        </form>

        <div class="divider">
            <div class="divider-line"></div>
            <span class="divider-text">or sign up with</span>
            <div class="divider-line"></div>
        </div>

        <div class="social-btns">
            <a href="#" class="social-btn">
                <svg class="social-icon" viewBox="0 0 24 24">
                    <path fill="#4285F4" d="M22.56 12.25c0-.78-.07-1.53-.2-2.25H12v4.26h5.92c-.26 1.37-1.04 2.53-2.21 3.31v2.77h3.57c2.08-1.92 3.28-4.74 3.28-8.09z"/>
                    <path fill="#34A853" d="M12 23c2.97 0 5.46-.98 7.28-2.66l-3.57-2.77c-.98.66-2.23 1.06-3.71 1.06-2.86 0-5.29-1.93-6.16-4.53H2.18v2.84C3.99 20.53 7.7 23 12 23z"/>
                    <path fill="#FBBC05" d="M5.84 14.09c-.22-.66-.35-1.36-.35-2.09s.13-1.43.35-2.09V7.07H2.18C1.43 8.55 1 10.22 1 12s.43 3.45 1.18 4.93l2.85-2.22.81-.62z"/>
                    <path fill="#EA4335" d="M12 5.38c1.62 0 3.06.56 4.21 1.64l3.15-3.15C17.45 2.09 14.97 1 12 1 7.7 1 3.99 3.47 2.18 7.07l3.66 2.84c.87-2.6 3.3-4.53 6.16-4.53z"/>
                </svg>
                Google
            </a>
            <a href="#" class="social-btn">
                <svg class="social-icon" viewBox="0 0 24 24" fill="#1877F2">
                    <path d="M24 12.073c0-6.627-5.373-12-12-12s-12 5.373-12 12c0 5.99 4.388 10.954 10.125 11.854v-8.385H7.078v-3.47h3.047V9.43c0-3.007 1.792-4.669 4.533-4.669 1.312 0 2.686.235 2.686.235v2.953H15.83c-1.491 0-1.956.925-1.956 1.874v2.25h3.328l-.532 3.47h-2.796v8.385C19.612 23.027 24 18.062 24 12.073z"/>
                </svg>
                Facebook
            </a>
        </div>

        <div class="auth-footer">
            Already have an account? <a href="{{ route('login') }}">Login</a>
        </div>
    </div>
</div>
@endsection
