@extends('layouts.app')

@section('title', 'Offer a Ride')

@section('styles')
    <style>
        .page-header {
            text-align: center;
            padding: 16px 0 20px;
        }

        .page-title {
            font-size: 24px;
            font-weight: 800;
            color: #1e3a5f;
            margin-bottom: 4px;
        }

        .page-subtitle {
            font-size: 13px;
            color: #64748b;
        }

        .step-indicator {
            display: flex;
            justify-content: center;
            gap: 8px;
            margin-bottom: 20px;
        }

        .step {
            width: 32px;
            height: 32px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 13px;
            font-weight: 700;
            background: #e2e8f0;
            color: #64748b;
        }

        .step.active {
            background: linear-gradient(135deg, #00aff5, #10b981);
            color: white;
        }

        .step.completed {
            background: #10b981;
            color: white;
        }

        .step-line {
            width: 30px;
            height: 3px;
            background: #e2e8f0;
            align-self: center;
            border-radius: 2px;
        }

        .step-line.completed {
            background: #10b981;
        }

        /* Cards */
        .card {
            background: white;
            border-radius: 16px;
            padding: 16px;
            margin-bottom: 12px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.04);
        }

        .card-title {
            font-size: 14px;
            font-weight: 700;
            color: #1e3a5f;
            margin-bottom: 14px;
            display: flex;
            align-items: center;
            gap: 8px;
        }

        .card-title svg {
            width: 18px;
            height: 18px;
            color: #00aff5;
        }

        /* Form */
        .form-row {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 12px;
            margin-bottom: 14px;
        }

        .form-row.single {
            grid-template-columns: 1fr;
        }

        .form-group {
            display: flex;
            flex-direction: column;
            gap: 6px;
        }

        .form-label {
            font-size: 11px;
            font-weight: 700;
            color: #64748b;
            text-transform: uppercase;
        }

        .form-input, .form-select {
            padding: 14px;
            border: 2px solid #e2e8f0;
            border-radius: 12px;
            font-size: 14px;
            font-weight: 600;
            color: #1e3a5f;
            background: #f8fafc;
            width: 100%;
        }

        .form-input:focus, .form-select:focus {
            outline: none;
            border-color: #00aff5;
            background: white;
        }

        .form-textarea {
            padding: 14px;
            border: 2px solid #e2e8f0;
            border-radius: 12px;
            font-size: 14px;
            font-weight: 600;
            color: #1e3a5f;
            background: #f8fafc;
            width: 100%;
            min-height: 80px;
            resize: none;
        }

        /* Amenities */
        .amenities-grid {
            display: grid;
            grid-template-columns: repeat(3, 1fr);
            gap: 8px;
        }

        .amenity-item {
            display: flex;
            align-items: center;
            gap: 6px;
            padding: 10px;
            background: #f8fafc;
            border-radius: 10px;
            font-size: 11px;
            font-weight: 600;
            color: #64748b;
            cursor: pointer;
            border: 2px solid transparent;
            transition: all 0.2s;
        }

        .amenity-item:has(input:checked) {
            background: #e0f7fa;
            border-color: #00aff5;
            color: #00aff5;
        }

        .amenity-item input {
            display: none;
        }

        .amenity-icon {
            font-size: 14px;
        }

        /* Vehicle Select */
        .vehicle-option {
            display: flex;
            align-items: center;
            gap: 12px;
            padding: 12px;
            background: #f8fafc;
            border-radius: 12px;
            margin-bottom: 8px;
            cursor: pointer;
            border: 2px solid transparent;
        }

        .vehicle-option:has(input:checked) {
            background: #e0f7fa;
            border-color: #00aff5;
        }

        .vehicle-option input {
            display: none;
        }

        .vehicle-img {
            width: 60px;
            height: 40px;
            border-radius: 8px;
            background: linear-gradient(135deg, #1e3a5f, #0d1b2a);
            display: flex;
            align-items: center;
            justify-content: center;
            color: #00aff5;
            overflow: hidden;
        }

        .vehicle-img img {
            width: 100%;
            height: 100%;
            object-fit: cover;
        }

        .vehicle-info {
            flex: 1;
        }

        .vehicle-name {
            font-size: 13px;
            font-weight: 700;
            color: #1e3a5f;
        }

        .vehicle-details {
            font-size: 11px;
            color: #64748b;
        }

        .vehicle-seats {
            font-size: 11px;
            font-weight: 700;
            color: #00aff5;
            background: #e0f7fa;
            padding: 4px 10px;
            border-radius: 8px;
        }

        .add-vehicle-btn {
            display: block;
            text-align: center;
            padding: 12px;
            background: #f0f9ff;
            color: #00aff5;
            border-radius: 10px;
            font-size: 12px;
            font-weight: 700;
            text-decoration: none;
            margin-top: 8px;
        }

        /* Price Section */
        .price-input-wrap {
            position: relative;
        }

        .price-prefix {
            position: absolute;
            left: 14px;
            top: 50%;
            transform: translateY(-50%);
            font-size: 14px;
            font-weight: 700;
            color: #64748b;
        }

        .price-input-wrap .form-input {
            padding-left: 40px;
        }

        .price-suggestion {
            font-size: 11px;
            color: #10b981;
            margin-top: 4px;
        }

        /* Submit Button */
        .submit-btn {
            display: block;
            width: 100%;
            padding: 16px;
            background: linear-gradient(135deg, #00aff5, #10b981);
            color: white;
            border: none;
            border-radius: 14px;
            font-size: 15px;
            font-weight: 700;
            cursor: pointer;
            margin-top: 16px;
        }

        .submit-btn:active {
            transform: scale(0.98);
        }

        .alert-success {
            background: #d1fae5;
            color: #065f46;
            padding: 12px;
            border-radius: 10px;
            font-size: 12px;
            font-weight: 600;
            margin-bottom: 12px;
        }

        .alert-error {
            background: #fee2e2;
            color: #991b1b;
            padding: 12px;
            border-radius: 10px;
            font-size: 12px;
            font-weight: 600;
            margin-bottom: 12px;
        }

        @media (max-width: 400px) {
            .form-row { grid-template-columns: 1fr; }
            .amenities-grid { grid-template-columns: repeat(2, 1fr); }
        }
    </style>
@endsection

@section('content')
    @if(session('success'))
        <div class="alert-success">✓ {{ session('success') }}</div>
    @endif

    @if($errors->any())
        <div class="alert-error">
            @foreach($errors->all() as $error)
                {{ $error }}<br>
            @endforeach
        </div>
    @endif

    <div class="page-header">
        <h1 class="page-title">🚗 Offer a Ride</h1>
        <p class="page-subtitle">Share your journey and earn money</p>
    </div>

    <div class="step-indicator">
        <div class="step active">1</div>
        <div class="step-line"></div>
        <div class="step">2</div>
        <div class="step-line"></div>
        <div class="step">3</div>
    </div>

    <form action="{{ route('rides.store') }}" method="POST">
        @csrf

        <!-- Route Section -->
        <div class="card">
            <h2 class="card-title">
                <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2.5">
                    <circle cx="12" cy="10" r="3"></circle>
                    <path d="M12 21.7C17.3 17 20 13 20 10a8 8 0 1 0-16 0c0 3 2.7 6.9 8 11.7z"></path>
                </svg>
                Route Details
            </h2>

            <div class="form-row">
                <div class="form-group">
                    <label class="form-label">From City</label>
                    <select name="from_city" class="form-select" required>
                        <option value="">Select departure</option>
                        @foreach($cities as $city)
                            <option value="{{ $city->id }}" {{ old('from_city') == $city->id ? 'selected' : '' }}>{{ $city->name }}</option>
                        @endforeach
                    </select>
                </div>
                <div class="form-group">
                    <label class="form-label">To City</label>
                    <select name="to_city" class="form-select" required>
                        <option value="">Select destination</option>
                        @foreach($cities as $city)
                            <option value="{{ $city->id }}" {{ old('to_city') == $city->id ? 'selected' : '' }}>{{ $city->name }}</option>
                        @endforeach
                    </select>
                </div>
            </div>

            <div class="form-row">
                <div class="form-group">
                    <label class="form-label">Pickup Point</label>
                    <input type="text" name="pickup_point" class="form-input" placeholder="e.g. F-7 Markaz" value="{{ old('pickup_point') }}" required>
                </div>
                <div class="form-group">
                    <label class="form-label">Drop Point</label>
                    <input type="text" name="drop_point" class="form-input" placeholder="e.g. Liberty Market" value="{{ old('drop_point') }}" required>
                </div>
            </div>
        </div>

        <!-- Date & Time Section -->
        <div class="card">
            <h2 class="card-title">
                <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2.5">
                    <rect x="3" y="4" width="18" height="18" rx="2"></rect>
                    <line x1="16" y1="2" x2="16" y2="6"></line>
                    <line x1="8" y1="2" x2="8" y2="6"></line>
                    <line x1="3" y1="10" x2="21" y2="10"></line>
                </svg>
                Date & Time
            </h2>

            <div class="form-row">
                <div class="form-group">
                    <label class="form-label">Date</label>
                    <input type="date" name="date" class="form-input" min="{{ date('Y-m-d') }}" value="{{ old('date', date('Y-m-d')) }}" required>
                </div>
                <div class="form-group">
                    <label class="form-label">Departure Time</label>
                    <input type="time" name="time" class="form-input" value="{{ old('time', '09:00') }}" required>
                </div>
            </div>
        </div>

        <!-- Vehicle Section -->
        <div class="card">
            <h2 class="card-title">
                <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2.5">
                    <path d="M19 17h2c.6 0 1-.4 1-1v-3c0-.9-.7-1.7-1.5-1.9C18.7 10.6 16 10 16 10s-1.3-1.4-2.2-2.3c-.5-.4-1.1-.7-1.8-.7H5c-.6 0-1.1.4-1.4.9l-1.4 2.9A3.7 3.7 0 0 0 2 12v4c0 .6.4 1 1 1h2"></path>
                    <circle cx="7" cy="17" r="2"></circle>
                    <circle cx="17" cy="17" r="2"></circle>
                </svg>
                Select Vehicle
            </h2>

            @forelse($vehicles as $vehicle)
                <label class="vehicle-option">
                    <input type="radio" name="vehicle_id" value="{{ $vehicle->id }}" {{ old('vehicle_id') == $vehicle->id || $loop->first ? 'checked' : '' }}>
                    <div class="vehicle-img">
                        @if($vehicle->vehicle_images && count($vehicle->vehicle_images) > 0)
                            <img src="{{ asset('storage/' . $vehicle->vehicle_images[0]) }}" alt="{{ $vehicle->brand }}">
                        @else
                            <svg width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                <path d="M19 17h2c.6 0 1-.4 1-1v-3c0-.9-.7-1.7-1.5-1.9C18.7 10.6 16 10 16 10s-1.3-1.4-2.2-2.3c-.5-.4-1.1-.7-1.8-.7H5c-.6 0-1.1.4-1.4.9l-1.4 2.9A3.7 3.7 0 0 0 2 12v4c0 .6.4 1 1 1h2"></path>
                                <circle cx="7" cy="17" r="2"></circle>
                                <circle cx="17" cy="17" r="2"></circle>
                            </svg>
                        @endif
                    </div>
                    <div class="vehicle-info">
                        <div class="vehicle-name">{{ $vehicle->brand }} {{ $vehicle->model }}</div>
                        <div class="vehicle-details">{{ $vehicle->year }} • {{ $vehicle->color }} • {{ $vehicle->license_plate }}</div>
                    </div>
                    <span class="vehicle-seats">{{ $vehicle->total_seats }} seats</span>
                </label>
            @empty
                <div style="text-align: center; padding: 20px; color: #64748b; font-size: 13px;">
                    No vehicles added yet
                </div>
            @endforelse

            <a href="{{ route('profile', ['tab' => 'vehicles']) }}" class="add-vehicle-btn">+ Add New Vehicle</a>
        </div>

        <!-- Seats & Price Section -->
        <div class="card">
            <h2 class="card-title">
                <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2.5">
                    <circle cx="12" cy="12" r="10"></circle>
                    <path d="M12 6v6l4 2"></path>
                </svg>
                Seats & Pricing
            </h2>

            <div class="form-row">
                <div class="form-group">
                    <label class="form-label">Available Seats</label>
                    <select name="seats" class="form-select" required>
                        <option value="1">1 Seat</option>
                        <option value="2">2 Seats</option>
                        <option value="3" selected>3 Seats</option>
                        <option value="4">4 Seats</option>
                        <option value="5">5 Seats</option>
                        <option value="6">6 Seats</option>
                    </select>
                </div>
                <div class="form-group">
                    <label class="form-label">Price per Seat</label>
                    <div class="price-input-wrap">
                        <span class="price-prefix">Rs</span>
                        <input type="number" name="price" class="form-input" placeholder="1500" value="{{ old('price') }}" min="100" required>
                    </div>
                    <span class="price-suggestion">💡 Suggested: Rs 1,000 - 2,500</span>
                </div>
            </div>
        </div>

        <!-- Amenities Section -->
        <div class="card">
            <h2 class="card-title">
                <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2.5">
                    <path d="M12 2l3.09 6.26L22 9.27l-5 4.87 1.18 6.88L12 17.77l-6.18 3.25L7 14.14 2 9.27l6.91-1.01L12 2z"></path>
                </svg>
                Amenities
            </h2>

            <div class="amenities-grid">
                <label class="amenity-item">
                    <input type="checkbox" name="amenities[]" value="AC">
                    <span class="amenity-icon">❄️</span> AC
                </label>
                <label class="amenity-item">
                    <input type="checkbox" name="amenities[]" value="Music">
                    <span class="amenity-icon">🎵</span> Music
                </label>
                <label class="amenity-item">
                    <input type="checkbox" name="amenities[]" value="WiFi">
                    <span class="amenity-icon">📶</span> WiFi
                </label>
                <label class="amenity-item">
                    <input type="checkbox" name="amenities[]" value="Charger">
                    <span class="amenity-icon">🔌</span> Charger
                </label>
                <label class="amenity-item">
                    <input type="checkbox" name="amenities[]" value="Snacks">
                    <span class="amenity-icon">🍿</span> Snacks
                </label>
                <label class="amenity-item">
                    <input type="checkbox" name="amenities[]" value="Luggage">
                    <span class="amenity-icon">🧳</span> Luggage
                </label>
            </div>
        </div>

        <!-- Preferences Section -->
        <div class="card">
            <h2 class="card-title">
                <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2.5">
                    <circle cx="12" cy="12" r="3"></circle>
                    <path d="M19.4 15a1.65 1.65 0 0 0 .33 1.82l.06.06a2 2 0 0 1 0 2.83 2 2 0 0 1-2.83 0l-.06-.06a1.65 1.65 0 0 0-1.82-.33 1.65 1.65 0 0 0-1 1.51V21a2 2 0 0 1-2 2 2 2 0 0 1-2-2v-.09A1.65 1.65 0 0 0 9 19.4a1.65 1.65 0 0 0-1.82.33l-.06.06a2 2 0 0 1-2.83 0 2 2 0 0 1 0-2.83l.06-.06a1.65 1.65 0 0 0 .33-1.82 1.65 1.65 0 0 0-1.51-1H3a2 2 0 0 1-2-2 2 2 0 0 1 2-2h.09A1.65 1.65 0 0 0 4.6 9a1.65 1.65 0 0 0-.33-1.82l-.06-.06a2 2 0 0 1 0-2.83 2 2 0 0 1 2.83 0l.06.06a1.65 1.65 0 0 0 1.82.33H9a1.65 1.65 0 0 0 1-1.51V3a2 2 0 0 1 2-2 2 2 0 0 1 2 2v.09a1.65 1.65 0 0 0 1 1.51 1.65 1.65 0 0 0 1.82-.33l.06-.06a2 2 0 0 1 2.83 0 2 2 0 0 1 0 2.83l-.06.06a1.65 1.65 0 0 0-.33 1.82V9a1.65 1.65 0 0 0 1.51 1H21a2 2 0 0 1 2 2 2 2 0 0 1-2 2h-.09a1.65 1.65 0 0 0-1.51 1z"></path>
                </svg>
                Ride Preferences
            </h2>

            <div class="amenities-grid">
                <label class="amenity-item">
                    <input type="checkbox" name="preferences[]" value="No Smoking">
                    <span class="amenity-icon">🚭</span> No Smoking
                </label>
                <label class="amenity-item">
                    <input type="checkbox" name="preferences[]" value="Pets OK">
                    <span class="amenity-icon">🐕</span> Pets OK
                </label>
                <label class="amenity-item">
                    <input type="checkbox" name="preferences[]" value="Women Only">
                    <span class="amenity-icon">👩</span> Women Only
                </label>
                <label class="amenity-item">
                    <input type="checkbox" name="preferences[]" value="Family">
                    <span class="amenity-icon">👨‍👩‍👧</span> Family
                </label>
                <label class="amenity-item">
                    <input type="checkbox" name="preferences[]" value="Quiet">
                    <span class="amenity-icon">🤫</span> Quiet Ride
                </label>
                <label class="amenity-item">
                    <input type="checkbox" name="preferences[]" value="Musical">
                    <span class="amenity-icon">🎶</span> Music OK
                </label>
            </div>
        </div>

        <!-- Notes Section -->
        <div class="card">
            <h2 class="card-title">
                <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2.5">
                    <path d="M14 2H6a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V8z"></path>
                    <polyline points="14 2 14 8 20 8"></polyline>
                    <line x1="16" y1="13" x2="8" y2="13"></line>
                    <line x1="16" y1="17" x2="8" y2="17"></line>
                </svg>
                Additional Notes (Optional)
            </h2>

            <div class="form-group">
                <textarea name="notes" class="form-textarea" placeholder="Any additional information for passengers...">{{ old('notes') }}</textarea>
            </div>
        </div>

        <button type="submit" class="submit-btn">🚀 Publish Ride</button>
    </form>
@endsection
