

<?php $__env->startSection('title', 'Users'); ?>
<?php $__env->startSection('page-title', 'Users Management'); ?>

<?php $__env->startSection('content'); ?>
    <div class="card">
        <div class="card-header">
            <h3 class="card-title">All Users (<?php echo e($users->total()); ?>)</h3>
            <a href="<?php echo e(route('admin.users.create')); ?>" class="btn btn-primary btn-sm">➕ Add User</a>
        </div>
        <table class="table">
            <thead>
                <tr>
                    <th>User</th>
                    <th>Phone</th>
                    <th>Type</th>
                    <th>KYC Status</th>
                    <th>Admin</th>
                    <th>Joined</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php $__empty_1 = true; $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr>
                        <td>
                            <div class="user-cell">
                                <div class="user-avatar-sm" style="background: <?php echo e($user->is_admin ? '#00aff5' : '#e2e8f0'); ?>; color: <?php echo e($user->is_admin ? 'white' : '#64748b'); ?>;">
                                    <?php echo e(substr($user->name, 0, 1)); ?>

                                </div>
                                <div>
                                    <div style="font-weight: 700;"><?php echo e($user->name); ?></div>
                                    <div style="font-size: 12px; color: #64748b;"><?php echo e($user->email); ?></div>
                                </div>
                            </div>
                        </td>
                        <td><?php echo e($user->phone ?? 'N/A'); ?></td>
                        <td>
                            <span class="badge badge-info"><?php echo e(ucfirst($user->user_type ?? 'passenger')); ?></span>
                        </td>
                        <td>
                            <?php if($user->is_verified): ?>
                                <span class="badge badge-success">Verified</span>
                            <?php elseif($user->verification_document): ?>
                                <span class="badge badge-warning">Pending</span>
                            <?php else: ?>
                                <span class="badge badge-danger">Not Submitted</span>
                            <?php endif; ?>
                        </td>
                        <td>
                            <?php if($user->is_admin): ?>
                                <span class="badge badge-success">Yes</span>
                            <?php else: ?>
                                <span class="badge badge-danger">No</span>
                            <?php endif; ?>
                        </td>
                        <td style="font-size: 13px; color: #64748b;"><?php echo e($user->created_at->format('M d, Y')); ?></td>
                        <td>
                            <div style="display: flex; gap: 8px; flex-wrap: wrap;">
                                <a href="<?php echo e(route('admin.users.edit', $user->id)); ?>" class="btn btn-sm" style="background: #e0f7fa; color: #0369a1;">Edit</a>
                                <?php if(!$user->is_verified && $user->verification_document): ?>
                                    <form action="<?php echo e(route('admin.users.verify', $user->id)); ?>" method="POST" style="display: inline;">
                                        <?php echo csrf_field(); ?>
                                        <button type="submit" class="btn btn-primary btn-sm">Verify</button>
                                    </form>
                                <?php endif; ?>
                                <form action="<?php echo e(route('admin.users.toggle-admin', $user->id)); ?>" method="POST" style="display: inline;">
                                    <?php echo csrf_field(); ?>
                                    <button type="submit" class="btn btn-sm" style="background: #ede9fe; color: #7c3aed;">
                                        <?php echo e($user->is_admin ? 'Remove Admin' : 'Make Admin'); ?>

                                    </button>
                                </form>
                                <?php if($user->id !== auth()->id()): ?>
                                    <form action="<?php echo e(route('admin.users.delete', $user->id)); ?>" method="POST" style="display: inline;" onsubmit="return confirm('Are you sure you want to delete this user?');">
                                        <?php echo csrf_field(); ?>
                                        <?php echo method_field('DELETE'); ?>
                                        <button type="submit" class="btn btn-danger btn-sm">Delete</button>
                                    </form>
                                <?php endif; ?>
                            </div>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td colspan="7" style="text-align: center; color: #64748b; padding: 40px;">No users found</td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>

    <!-- Pagination -->
    <div style="display: flex; justify-content: center; margin-top: 20px;">
        <?php echo e($users->links()); ?>

    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layout', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\gg\ridepool\resources\views/admin/users.blade.php ENDPATH**/ ?>