

<?php $__env->startSection('title', 'Inbox'); ?>

<?php $__env->startSection('styles'); ?>
    <style>
        .page-card {
            background: white;
            padding: 40px 24px;
            border-radius: 24px;
            box-shadow: 0 10px 40px rgba(0,0,0,0.05);
            max-width: 500px;
            margin: 20px auto;
            text-align: center;
        }

        .page-icon {
            width: 70px;
            height: 70px;
            background: linear-gradient(135deg, rgba(0, 175, 245, 0.1) 0%, rgba(16, 185, 129, 0.1) 100%);
            border-radius: 20px;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 20px;
            animation: iconFloat 3s ease-in-out infinite;
        }

        @keyframes iconFloat {
            0%, 100% { transform: translateY(0); }
            50% { transform: translateY(-8px); }
        }

        .page-icon svg {
            width: 32px;
            height: 32px;
            color: var(--primary);
        }

        .page-title {
            font-size: 22px;
            font-weight: 800;
            margin-bottom: 10px;
            color: var(--secondary);
        }

        .page-description {
            color: var(--text-muted);
            font-weight: 500;
            font-size: 14px;
            margin-bottom: 24px;
            line-height: 1.6;
        }

        .btn-home {
            background: linear-gradient(135deg, #00aff5 0%, #10b981 100%);
            color: white;
            padding: 14px 28px;
            border-radius: 14px;
            font-weight: 700;
            font-size: 14px;
            text-decoration: none;
            display: inline-flex;
            align-items: center;
            gap: 8px;
            transition: all 0.3s ease;
            box-shadow: 0 8px 20px rgba(0, 175, 245, 0.3);
        }

        .btn-home:active {
            transform: scale(0.95);
        }

        .coming-soon-badge {
            display: inline-block;
            background: #fef3c7;
            color: #d97706;
            padding: 6px 14px;
            border-radius: 20px;
            font-size: 11px;
            font-weight: 700;
            margin-bottom: 16px;
        }
    </style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="page-card">
        <span class="coming-soon-badge">Coming Soon</span>
        <div class="page-icon">
            <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2.5">
                <path d="M21 15a2 2 0 0 1-2 2H7l-4 4V5a2 2 0 0 1 2-2h14a2 2 0 0 1 2 2z"></path>
            </svg>
        </div>
        <h1 class="page-title">Messages</h1>
        <p class="page-description">
            Chat directly with your drivers and passengers. Get real-time updates about your rides.
        </p>
        <a href="<?php echo e(route('home')); ?>" class="btn-home">
            <svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2.5">
                <path d="M19 12H5"></path>
                <path d="M12 19l-7-7 7-7"></path>
            </svg>
            Back to Home
        </a>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\gg\ridepool\resources\views/inbox.blade.php ENDPATH**/ ?>