

<?php $__env->startSection('title', 'Settings'); ?>
<?php $__env->startSection('page-title', 'Settings'); ?>

<?php $__env->startSection('content'); ?>
    <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(400px, 1fr)); gap: 24px;">
        <!-- General Settings -->
        <div class="card">
            <div class="card-header">
                <h3 class="card-title">General Settings</h3>
            </div>
            <div style="padding: 24px;">
                <div style="margin-bottom: 20px;">
                    <label style="display: block; font-size: 12px; font-weight: 700; color: #64748b; margin-bottom: 8px;">Site Name</label>
                    <input type="text" value="KKH Ride" style="width: 100%; padding: 12px 16px; border: 2px solid #e2e8f0; border-radius: 10px; font-size: 14px;">
                </div>
                <div style="margin-bottom: 20px;">
                    <label style="display: block; font-size: 12px; font-weight: 700; color: #64748b; margin-bottom: 8px;">Support Email</label>
                    <input type="email" value="support@kkhride.com" style="width: 100%; padding: 12px 16px; border: 2px solid #e2e8f0; border-radius: 10px; font-size: 14px;">
                </div>
                <div style="margin-bottom: 20px;">
                    <label style="display: block; font-size: 12px; font-weight: 700; color: #64748b; margin-bottom: 8px;">Service Fee (PKR)</label>
                    <input type="number" value="50" style="width: 100%; padding: 12px 16px; border: 2px solid #e2e8f0; border-radius: 10px; font-size: 14px;">
                </div>
                <button class="btn btn-primary">Save Changes</button>
            </div>
        </div>

        <!-- Quick Stats -->
        <div class="card">
            <div class="card-header">
                <h3 class="card-title">System Info</h3>
            </div>
            <div style="padding: 24px;">
                <div style="display: flex; justify-content: space-between; padding: 12px 0; border-bottom: 1px solid #f1f5f9;">
                    <span style="color: #64748b;">Laravel Version</span>
                    <span style="font-weight: 700;"><?php echo e(app()->version()); ?></span>
                </div>
                <div style="display: flex; justify-content: space-between; padding: 12px 0; border-bottom: 1px solid #f1f5f9;">
                    <span style="color: #64748b;">PHP Version</span>
                    <span style="font-weight: 700;"><?php echo e(phpversion()); ?></span>
                </div>
                <div style="display: flex; justify-content: space-between; padding: 12px 0; border-bottom: 1px solid #f1f5f9;">
                    <span style="color: #64748b;">Server Time</span>
                    <span style="font-weight: 700;"><?php echo e(now()->format('M d, Y H:i')); ?></span>
                </div>
                <div style="display: flex; justify-content: space-between; padding: 12px 0;">
                    <span style="color: #64748b;">Environment</span>
                    <span class="badge badge-success"><?php echo e(app()->environment()); ?></span>
                </div>
            </div>
        </div>

        <!-- Payment Settings -->
        <div class="card">
            <div class="card-header">
                <h3 class="card-title">Payment Methods</h3>
            </div>
            <div style="padding: 24px;">
                <div style="display: flex; align-items: center; justify-content: space-between; padding: 12px 0; border-bottom: 1px solid #f1f5f9;">
                    <div style="display: flex; align-items: center; gap: 12px;">
                        <span style="font-size: 24px;">💵</span>
                        <span style="font-weight: 700;">Cash on Ride</span>
                    </div>
                    <span class="badge badge-success">Active</span>
                </div>
                <div style="display: flex; align-items: center; justify-content: space-between; padding: 12px 0; border-bottom: 1px solid #f1f5f9;">
                    <div style="display: flex; align-items: center; gap: 12px;">
                        <span style="font-size: 24px;">📱</span>
                        <span style="font-weight: 700;">JazzCash</span>
                    </div>
                    <span class="badge badge-success">Active</span>
                </div>
                <div style="display: flex; align-items: center; justify-content: space-between; padding: 12px 0;">
                    <div style="display: flex; align-items: center; gap: 12px;">
                        <span style="font-size: 24px;">📲</span>
                        <span style="font-weight: 700;">Easypaisa</span>
                    </div>
                    <span class="badge badge-success">Active</span>
                </div>
            </div>
        </div>

        <!-- Database Actions -->
        <div class="card">
            <div class="card-header">
                <h3 class="card-title">Database Actions</h3>
            </div>
            <div style="padding: 24px;">
                <p style="color: #64748b; font-size: 14px; margin-bottom: 16px;">
                    Use these actions carefully. They can affect your database.
                </p>
                <div style="display: flex; gap: 12px; flex-wrap: wrap;">
                    <button class="btn" style="background: #fef3c7; color: #92400e;">Clear Cache</button>
                    <button class="btn" style="background: #fee2e2; color: #991b1b;">Seed Demo Data</button>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layout', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\gg\ridepool\resources\views/admin/settings.blade.php ENDPATH**/ ?>